<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Lead_Generation extends CI_Controller {
    
    public function __construct(){
        
        parent::__construct();
        
        $this->load->database();
		$this->load->library(['ion_auth', 'form_validation']);
		$this->load->helper(['url', 'language'], ['form']);
		$this->lang->load('auth');
        
        if (!$this->ion_auth->logged_in()){
          redirect('auth/login');
        }
    }
    
    public function index(){
        $this->load->model('Lead_model');
        $result['data'] = $this->Lead_model->get_records();
	    $this->load->view('lead-generation/header');
		$this->load->view('lead-generation/lead_generation', $result);
		$this->load->view('lead-generation/footer');
	}
	
	public function logout(){
	     $this->ion_auth->logout();
	     redirect('auth/login');
	}
	
	public function addleadgeneration(){
	    $this->load->view('lead-generation/header');
		$this->load->view('lead-generation/add');
		$this->load->view('lead-generation/footer');
	}
	
	public function editleadgeneration($id){
	    $this->load->model('Lead_model');
	    $result['data'] = $this->Lead_model->get_record($id);
	    
	    $this->load->view('lead-generation/header');
		$this->load->view('lead-generation/edit', $result);
		$this->load->view('lead-generation/footer');
	}
 
	public function add(){
	    $business_name                                  = $this->input->post('business_name');
	    $business_address                               = $this->input->post('business_address');
	    $phone                                          = $this->input->post('phone');
	    $website_email                                  = $this->input->post('website_email');
	    $business_type_other                            = $this->input->post('business_type_other');
	    $call_disposition_answered_right_party_answer   = $this->input->post('call_disposition_answered_right_party_answer');
	    $call_disposition_unanswered_line_busy          = $this->input->post('call_disposition_unanswered_line_busy');
	    $additional_notes                               = $this->input->post('additional_notes');
	    
	    $this->form_validation->set_rules('business_name', 'Business Name', 'required');
	    $this->form_validation->set_rules('business_address', 'Business Address', 'required');
	    $this->form_validation->set_rules('phone', 'Phone', 'required');
	    
	    if ($this->form_validation->run() == FALSE){
            $this->load->view('lead-generation/header');
		    $this->load->view('lead-generation/add');
		    $this->load->view('lead-generation/footer');
        } else { 
            
            $data = array(
                'Column_1' => $business_name ,
                'Column_2' => $business_address,
                'Column_3' => $phone,
                'Column_4' => $website_email,
                'Column_5' => $business_type_other,
                'Column_6' => $call_disposition_answered_right_party_answer,
                'Column_7' => $call_disposition_unanswered_line_busy,
                'Column_8' => $additional_notes,
            );
            
            $this->load->model('Lead_model');
            $result = $this->Lead_model->insert_lead( $data );
            
            if($result){
                redirect('Lead_Generation/success_add_lead');
			}
			else{
				redirect('Lead_Generation/fail_add_lead');
			}
			
			//Loading View
            $this->load->view('lead-generation/header');
	        $this->load->view('lead-generation/add', $data);
	        $this->load->view('lead-generation/footer');
        }
	}
	
	public function success_add_lead(){
	    $result['message'] = 'Data Inserted Successfully!';
	    
	    $this->load->model('Lead_model');
        $result['data'] = $this->Lead_model->get_records();
	    $this->load->view('lead-generation/header');
		$this->load->view('lead-generation/lead_generation', $result);
		$this->load->view('lead-generation/footer');

	}
	
	public function fail_add_lead(){
	    $data['message'] = 'Data Not Inserted!';
	    $this->load->view('lead-generation/header');
	    $this->load->view('lead-generation/add', $data);
	    $this->load->view('lead-generation/footer');
	}
	
	public function edit(){
	    $business_name                                  = $this->input->post('business_name');
	    $business_address                               = $this->input->post('business_address');
	    $phone                                          = $this->input->post('phone');
	    $website_email                                  = $this->input->post('website_email');
	    $business_type_other                            = $this->input->post('business_type_other');
	    $call_disposition_answered_right_party_answer   = $this->input->post('call_disposition_answered_right_party_answer');
	    $call_disposition_unanswered_line_busy          = $this->input->post('call_disposition_unanswered_line_busy');
	    $additional_notes                               = $this->input->post('additional_notes');
	    $id                                             = $this->input->post('id');
	    
	    $this->form_validation->set_rules('business_name', 'Business Name', 'required');
	    $this->form_validation->set_rules('business_address', 'Business Address', 'required');
	    $this->form_validation->set_rules('phone', 'Phone', 'required');
	    
	    if ($this->form_validation->run() == FALSE){
	        
            $this->load->model('Lead_model');
    	    $result['data'] = $this->Lead_model->get_record($id);
    	    
    	    $this->load->view('lead-generation/header');
    		$this->load->view('lead-generation/edit', $result);
    		$this->load->view('lead-generation/footer');
            
        } else { 
            
            $data = array(
                'Column_1' => $business_name ,
                'Column_2' => $business_address,
                'Column_3' => $phone,
                'Column_4' => $website_email,
                'Column_5' => $business_type_other,
                'Column_6' => $call_disposition_answered_right_party_answer,
                'Column_7' => $call_disposition_unanswered_line_busy,
                'Column_8' => $additional_notes,
            );
            
            $this->load->model('Lead_model');
            $resultedit = $this->Lead_model->update_lead( $id, $data );
            
            if($resultedit){
                $this->load->model('Lead_model');
                
        	    $result['data'] = $this->Lead_model->get_record($id);
    	        $result['message'] = 'Data Edit Successfully!';
    	        
        	    $this->load->view('lead-generation/header');
        		$this->load->view('lead-generation/edit', $result);
        		$this->load->view('lead-generation/footer');
			}
			else{
				$this->load->model('Lead_model');
                
        	    $result['data'] = $this->Lead_model->get_record($id);
    	        $result['message'] = 'Data Not Edit!';
    	        
        	    $this->load->view('lead-generation/header');
        		$this->load->view('lead-generation/edit', $result);
        		$this->load->view('lead-generation/footer');
			}

        }
	}
	
    public function deleteleadgeneration($id){
	    $this->load->model('Lead_model');
	    $resultdelete = $this->Lead_model->delete_lead($id);
	    if( $resultdelete ){
            $result['message'] = 'Data Deleted Successfully!';
	    }
	    $result['data'] = $this->Lead_model->get_records();
	    
	    $this->load->view('lead-generation/header');
		$this->load->view('lead-generation/lead_generation', $result);
		$this->load->view('lead-generation/footer');
	}
	
	    public function showleads()
    {
    
        $draw = intval($this->input->post("draw"));
        $start = intval($this->input->post("start"));
        $length = intval($this->input->post("length"));
        $order = $this->input->post("order");
        $search= $this->input->post("search");
        $search = $search['value'];
        $col = 0;
        $dir = "";
        if(!empty($order))
        {
            foreach($order as $o)
            {
                $col = $o['column'];
                $dir= $o['dir'];
            }
        }

        if($dir != "asc" && $dir != "desc")
        {
            $dir = "desc";
        }
        $valid_columns = array(
            0=>'ID',
            1=>'Column_1',
            2=>'Column_2',
            3=>'Column_3',
            4=>'Column_4',
            5=>'Column_5',
            6=>'Column_6',
            7=>'Column_7',
            8=>'Column_8',
        );
        if(!isset($valid_columns[$col]))
        {
            $order = null;
        }
        else
        {
            $order = $valid_columns[$col];
        }
        if($order !=null)
        {
            $this->db->order_by($order, $dir);
        }
        
        if(!empty($search))
        {
            $x=0;
            foreach($valid_columns as $sterm)
            {
                if($x==0)
                {
                    $this->db->like($sterm,$search);
                }
                else
                {
                    $this->db->or_like($sterm,$search);
                }
                $x++;
            }                 
        }
        $this->db->limit($length,$start);
        $leads = $this->db->get("euLead_Generation_Ongoing");
        $data = array();
        

        foreach($leads->result() as $rows)
        {

            $data[]= array(
                $rows->id,
                $rows->Column_1,
                $rows->Column_2,
                $rows->Column_3,
                $rows->Column_4,
                $rows->Column_5,
                $rows->Column_6,
                $rows->Column_7,
                $rows->Column_8,
                
                '<a href="'.base_url().'index.php/Lead_Generation/editleadgeneration/'.$rows->id.'" class="btn btn-warning mr-1">Edit</a>'
            );     
        }
   

        $leads = $this->totalleads();
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $leads,
            "recordsFiltered" => $leads,
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }
    
        public function totalleads()
    {
        $query = $this->db->select("COUNT(*) as num")->get("euLead_Generation_Ongoing");
        $result = $query->row();
        if(isset($result)) return $result->num;
        return 0;
    }
}



